-------------------------------------------------------------------------------------------------------------------
-- REVISION 6 LUA Scripts (Ov3rHell3XoduZ)
-- MusicWheel and Stuffs Scripts.
-------------------------------------------------------------------------------------------------------------------

-------------------------------------------------------------------------------------------------------------------
-- MUSIC WHEEL TRANSFORM FUNCTION: Linear MusicWheel.
-------------------------------------------------------------------------------------------------------------------
function music_wheel_transform(self,offsetFromCenter,_fake1,_fake2)
	self:x((1-math.cos(offsetFromCenter/math.pi))*0)
	self:y(offsetFromCenter*16)
end

-------------------------------------------------------------------------------------------------------------------
-- GLOBAL MUSICWHEEL PARAMETERS: MusicWheel X & Y Position / OnCommand.
-------------------------------------------------------------------------------------------------------------------
function MusicWheelX()
	local PosX
	local Online = IsNetConnected()
	
	if Online then
		PosX = CenterX()
	else
		PosX = CenterX()
	end
	return PosX
end

function MusicWheelY()
	local PosY
	local Online = IsNetConnected()
	
	if Online then
		PosY = CenterY()+48
	else
		PosY = CenterY()+48
	end
	return PosY
end

function MusicWheelOnCommand(self) 
	self:draworder(-1):fov(90)
end